unit Progress;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons;

type
  TProgressBox = class(TForm)
    BitBtn1: TBitBtn;
    Title: TLabel;
    ProgressBar: TPanel;
    PaintBox1: TPaintBox;
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
  private
    { Private declarations }
    FCancelled: boolean;
    FProgress: integer;
  public
    { Public declarations }
    function SetProgress(PercentDone: integer): boolean;
  end;

var
  ProgressBox: TProgressBox;

implementation

{$R *.DFM}

function TProgressBox.SetProgress(PercentDone: integer): boolean;
begin
  ProgressBar.Caption := Format('%d%%',[PercentDone]);
  if FProgress <> PercentDone then
  begin
    FProgress := PercentDone;
    ProgressBar.Invalidate
  end;
  Result := not FCancelled
end;


procedure TProgressBox.FormShow(Sender: TObject);
begin
  FProgress := 0;
  FCancelled := false
end;

procedure TProgressBox.BitBtn1Click(Sender: TObject);
begin
  FCancelled := true
end;


procedure TProgressBox.PaintBox1Paint(Sender: TObject);
begin
   with PaintBox1 do
    PatBlt(Canvas.Handle,0,0,(width*FProgress) div 100, height,$F50225)
end;

end.
